#ifndef STUDENTTESTSCORES_H
#define STUDENTTESTSCORES_H
#include <string>
using namespace std;

const double DEFAULT_SCORE = 0.0;

class StudentTestScores
{
private:
  string studentName;  // Imi i nazwisko studenta
  double *testScores;  // Wskanik do tablicy z wynikami testw
  int numTestScores;   // Liczba wynikw testw

  // Funkcja prywatna tworzca
  // tablic wynikw testw
  void createTestScoresArray(int size)
  {
    numTestScores = size;
    testScores = new double[size];
    for (int i = 0; i < size; i++)
      testScores[i] = DEFAULT_SCORE;
  }

public:
  // Konstruktor
  StudentTestScores(string name, int numScores)
    { studentName = name;
      createTestScoresArray(numScores); }

  // Destruktor
  ~StudentTestScores()
    { delete[] testScores; }

  // Funkcja setTestScore() zapisujca
  // wynik testu
  void setTestScore(double score, int index)
    { testScores[index] = score; }

  // Funkcja zapisujca imi i nazwisko studenta
  void setStudentName(string name)
    { studentName = name; }

  // Funkcja zwracajca imi i nazwisko studenta
  string getStudentName() const
    { return studentName; }

  // Funkcja zwracajca liczb testw
  int getNumTestScores() const
    { return numTestScores; }

  // Funkcja zwracajca wynik wskazanego testu
  double getTestScore(int index) const
    { return testScores[index]; }
};
#endif
